Program ListaJednokierunkowa;
uses CRT;

{TYPY}
type

ElementListyPtr = ^ElementListy;

{ Struktura reprezentujaca element listy }
ElementListy = record
    wartosc: integer;
    nastepny : ElementListyPtr;
end;

{ZMIENNE}
var
    liczba, code: integer;
    bufor : String;
    glowa, temp: ElementListyPtr;

{PROCEDURY I FUNKCJE}

{ Sprawdza, czy liczba jest parzysta }
function czyParzysta(liczba : integer) : boolean;
begin
    czyParzysta := (liczba mod 2) = 0;
end;

{ Procedura dodajaca element do listy }
procedure dodajDoListy(liczba: integer);
var
    nowyElement, temp : ElementListyPtr;
begin
     New(nowyElement); { tworzony jest nowy element }
     nowyElement^.wartosc := liczba; { wypelniana jest wartosc elementu }
     nowyElement^.nastepny := nil;
     if glowa = nil  then { jezeli nie ma zadnego elementu na liscie }
         begin
             glowa := nowyElement; { nowy element staje sie pierwszym elementem na liscie }
         end
     else
         begin
             { jezeli sa juz elementy na liscie, stworz tymczasowy wskaznik wskazujacy na poczatek listy }
             temp := glowa;

             { przesuwamy tymczasowy wskaznik dopoki istnieje element nastepny }
             while (temp^.nastepny <> nil) do
             begin
                temp := temp^.nastepny;
             end;

             temp^.nastepny := nowyElement;  { ostatni element wskazuje na nowododany }
             nowyElement^.nastepny := nil;     { nowo dodany nie wskazuje na zaden inny element }
         end;
end;

begin
    repeat
        WriteLn();
        WriteLn('Podaj liczbe (ENTER bez liczby, aby zakonczyc) ');
        ReadLn(bufor);

        if bufor <> '' then               { jezeli bufor nie jest pusty }
                begin
                    Val(bufor, liczba, code);        { konwertuj ze stringa na liczbe }
                    dodajDoListy(liczba);            { dodaj do listy }
                end;

    until bufor = '';

    WriteLn();
    WriteLn('Liczby parzyste: ');

    { toworzymy tymczasowy wskaznik do wskazywania aktualnego elementu na liscie }
    New(temp);
    temp^ := glowa^;

    while temp <> nil do { dopoki element rozny od nil }
        begin
                { wypisz liczbe jezeli parzysta }
            if czyParzysta(temp^.wartosc) then
                                Write(temp^.wartosc,', ');
                                { niech tymczasowy wskaznik wskazuje na nastepny element na liscie }
            temp := temp^.nastepny;
        end;

    WriteLn();
    WriteLn('Nacisnij klawisz ENTER by zakonczyc...');
    ReadKey;

end.

